/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.settings.user;

import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.settings.user.DefaultUserSettings;
import com.ibm.hwmca.fw.settings.user.StatusBackgroundConstants;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ObjectBackgroundSettings
implements Serializable,
UserSettings,
Cloneable {
    private static final String TRACE_MASKT = "HUSTBE T";
    private static final String TRACE_MASKF = "HUSTBE F";
    private static final String TRACE_MASKD = "HUSTBE D";
    public static final String CLASS_NAME = "com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings";
    private static final String HELP_PANEL_NAME = "ObjectBackgroundSettingsPanel";
    private static final String HELP_PANEL_ID = "@ObjectBackgroundSettingsPanel";
    private static final String HELP_PANEL_PROPERTIES = "HELPSET:basehelp.hs;HELPID:com.ibm.hwmca.base.settings.user.res.ObjectBackgroundSettingsRes.ObjectBackgroundSettingsPanel";
    private static final LocalizableText ACCEPTABLE_TEXT = new LocalizableText("com/ibm/hwmca/fw/res/common", "state.acceptable.text");
    private static final LocalizableText UNACCEPTABLE_TEXT = new LocalizableText("com/ibm/hwmca/fw/res/common", "state.unacceptable.text");
    private String acceptableColor = "/res/com/ibm/hwmca/fw/images/green.gif";
    private String unacceptableColor = "/res/com/ibm/hwmca/fw/images/red.gif";
    private String acceptablePattern = "/res/com/ibm/hwmca/fw/images/vertical.gif";
    private String unacceptablePattern = "/res/com/ibm/hwmca/fw/images/horizontal.gif";
    private HashMap attentionColors = new HashMap();
    private HashMap attentionPatterns = new HashMap();
    private HashMap attentionUIInfos = new HashMap();
    private transient Object lock;
    private HashMap colorsStatusMap = new HashMap();
    private HashMap patternsStatusMap = new HashMap();
    private boolean useColorsStatus = true;
    private boolean useColorsOther = true;

    public ObjectBackgroundSettings(Properties properties) {
        this.setUseColorsStatus(Boolean.valueOf((String)properties.get("background.usecolors.status")));
        this.setUseColorsOther(Boolean.valueOf((String)properties.get("background.usecolors.other")));
        this.acceptableColor = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.acceptable.color");
        this.acceptablePattern = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.acceptable.pattern");
        this.unacceptableColor = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.unacceptable.color");
        this.unacceptablePattern = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.unacceptable.pattern");
        String colorImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.exceptions.color");
        String patternImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.exceptions.pattern");
        this.add(Status.EXCEPTIONS, colorImageName, patternImageName);
        colorImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.nopower.color");
        patternImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.nopower.pattern");
        this.add(Status.NO_POWER, colorImageName, patternImageName);
        colorImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.notcommunicating.color");
        patternImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.notcommunicating.pattern");
        this.add(Status.NOT_COMMUNICATING, colorImageName, patternImageName);
        colorImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.notoperating.color");
        patternImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.notoperating.pattern");
        this.add(Status.NOT_OPERATING, colorImageName, patternImageName);
        colorImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.operating.color");
        patternImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.operating.pattern");
        this.add(Status.OPERATING, colorImageName, patternImageName);
        colorImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.service.color");
        patternImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.service.pattern");
        this.add(Status.SERVICE, colorImageName, patternImageName);
        colorImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.msgpending.color");
        patternImageName = "/res/com/ibm/hwmca/fw/images/" + (String)properties.get("background.status.msgpending.pattern");
        this.addAttention(ManagedObject.getDefaultAttentionTaskObjectId(), colorImageName, patternImageName);
    }

    public static boolean addStatus(Status status, String colorImageName, String patternImageName) {
        Trace.trace(TRACE_MASKF, "-> ObjectBackgroundSettings.addStatus()");
        boolean result = false;
        if (CommonSystem.getCommonSystem().isLocationUnified() || CommonSystem.getCommonSystem().isLocationServer()) {
            Trace.trace(TRACE_MASKD, "   adding status " + status);
            Trace.trace(TRACE_MASKD, "   color is " + colorImageName);
            Trace.trace(TRACE_MASKD, "   pattern is " + patternImageName);
            ObjectBackgroundSettings defaultSettings = (ObjectBackgroundSettings)DefaultUserSettings.getDefaultUserSettings().getUserSettings(CLASS_NAME);
            result = defaultSettings.add(status, colorImageName, patternImageName);
        }
        Trace.trace(TRACE_MASKF, "<- ObjectBackgroundSettings.addStatus()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(Status status, String colorImageName, String patternImageName) {
        boolean result = true;
        Object object = this.getLock();
        synchronized (object) {
            if (this.colorsStatusMap.containsKey(status)) {
                result = false;
            } else {
                this.colorsStatusMap.put(status, colorImageName);
                this.patternsStatusMap.put(status, patternImageName);
            }
        }
        return result;
    }

    public static ObjectBackgroundSettings getSettingsForCurrentUserContext() {
        ObjectBackgroundSettings result = null;
        if (CommonSystem.getCommonSystem().isLocationUnified() || CommonSystem.getCommonSystem().isLocationServer()) {
            Map settings = User.getUser().getAllUserSettings();
            result = (ObjectBackgroundSettings)settings.get(CLASS_NAME);
        }
        return result;
    }

    public boolean useColorsStatus() {
        return this.useColorsStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAttention(ObjectId taskObjectId, String colorImage, String patternImage) {
        boolean result = true;
        Object object = this.getLock();
        synchronized (object) {
            if (this.attentionColors.containsKey(taskObjectId)) {
                result = false;
            } else {
                this.attentionColors.put(taskObjectId, colorImage);
                this.attentionPatterns.put(taskObjectId, patternImage);
                ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
                this.attentionUIInfos.put(taskObjectId, mom.getProperty(taskObjectId, "UIInfo"));
            }
        }
        return result;
    }

    public boolean useColorsOther() {
        return this.useColorsOther;
    }

    public void setUseColorsStatus(boolean useColorsStatus) {
        this.useColorsStatus = useColorsStatus;
    }

    public void setUseColorsOther(boolean useColorsOther) {
        this.useColorsOther = useColorsOther;
    }

    public boolean usePatternsStatus() {
        return !this.useColorsStatus;
    }

    public boolean usePatternsOther() {
        return !this.useColorsOther;
    }

    public String getBackgroundImageName(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("'status' argument is null.");
        }
        if (this.useColorsStatus) {
            return this.getColorBackgroundImageName(status);
        }
        return this.getPatternBackgroundImageName(status);
    }

    public String getBackgroundImageName(boolean acceptable) {
        if (acceptable) {
            return this.getAcceptableImageName();
        }
        return this.getUnacceptableImageName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIInfo[] getAttentionUIInfos() {
        UIInfo[] result = null;
        Object object = this.getLock();
        synchronized (object) {
            result = new UIInfo[this.attentionUIInfos.size()];
            Iterator iterator = this.attentionUIInfos.values().iterator();
            int next = 0;
            while (iterator.hasNext()) {
                result[next++] = (UIInfo)iterator.next();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIInfo getAttentionUIInfo(ObjectId taskObjectId) {
        Object object = this.getLock();
        synchronized (object) {
            return (UIInfo)this.attentionUIInfos.get(taskObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId[] getAttentionTaskObjectIds() {
        ObjectId[] result = null;
        Object object = this.getLock();
        synchronized (object) {
            result = new ObjectId[this.attentionUIInfos.size()];
            Iterator iterator = this.attentionUIInfos.keySet().iterator();
            int next = 0;
            while (iterator.hasNext()) {
                result[next++] = (ObjectId)iterator.next();
            }
        }
        return result;
    }

    public String getAttentionImageName(ObjectId taskObjectId) {
        if (taskObjectId == null) {
            throw new IllegalArgumentException("'taskObjectId' argument is null.");
        }
        HashMap attentionMap = this.useColorsOther ? this.attentionColors : this.attentionPatterns;
        return (String)attentionMap.get(taskObjectId);
    }

    public String getAnimatedAttentionImageName(ObjectId taskObjectId) {
        if (taskObjectId == null) {
            throw new IllegalArgumentException("'taskObjectId' argument is null.");
        }
        String sImageName = this.getAttentionImageName(taskObjectId);
        return StatusBackgroundConstants.getAnimatedForImageName(sImageName);
    }

    public String getColorBackgroundImageName(Status status) {
        return (String)this.colorsStatusMap.get(status);
    }

    public String getPatternBackgroundImageName(Status status) {
        return (String)this.patternsStatusMap.get(status);
    }

    public void setBackgroundImageName(Status status, String fileName) {
        HashMap statusMap = this.useColorsStatus ? this.colorsStatusMap : this.patternsStatusMap;
        Trace.trace(TRACE_MASKD, "   changing image for Status " + status + " from " + statusMap.get(status) + " to " + fileName);
        statusMap.put(status, fileName);
    }

    public boolean updateFromDefault() {
        Map settings;
        ObjectBackgroundSettings defaultSettings;
        Status[] defaultStatus;
        boolean result = false;
        if ((CommonSystem.getCommonSystem().isLocationUnified() || CommonSystem.getCommonSystem().isLocationServer()) && (defaultStatus = (defaultSettings = (ObjectBackgroundSettings)(settings = DefaultUserSettings.getDefaultUserSettings().getUserSettings()).get(CLASS_NAME)).getStatus()).length > this.colorsStatusMap.size()) {
            Object newStatus = null;
            int i = 0;
            while (i < defaultStatus.length) {
                if (!this.colorsStatusMap.containsKey(defaultStatus[i])) {
                    this.colorsStatusMap.put(defaultStatus[i], defaultSettings.getColorBackgroundImageName(defaultStatus[i]));
                    this.patternsStatusMap.put(defaultStatus[i], defaultSettings.getPatternBackgroundImageName(defaultStatus[i]));
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    public String getAcceptableImageName() {
        if (this.useColorsStatus) {
            return this.acceptableColor;
        }
        return this.acceptablePattern;
    }

    public void setAcceptableImageName(String imageName) {
        Trace.trace(TRACE_MASKF, "<> ObjectBackgroundSettings.setAcceptableImageName(), imageName=" + imageName);
        if (this.useColorsStatus) {
            this.acceptableColor = imageName;
        } else {
            this.acceptablePattern = imageName;
        }
    }

    public String getUnacceptableImageName() {
        if (this.useColorsStatus) {
            return this.unacceptableColor;
        }
        return this.unacceptablePattern;
    }

    public void setUnacceptableImageName(String imageName) {
        Trace.trace(TRACE_MASKF, "<> ObjectBackgroundSettings.setUnacceptableImageName(), imageName=" + imageName);
        if (this.useColorsStatus) {
            this.unacceptableColor = imageName;
        } else {
            this.unacceptablePattern = imageName;
        }
    }

    public LocalizableText getAcceptableText() {
        return ACCEPTABLE_TEXT;
    }

    public LocalizableText getUnacceptableText() {
        return UNACCEPTABLE_TEXT;
    }

    public void setAttentionImageName(ObjectId taskObjectId, String imageName) {
        HashMap map;
        Trace.trace(TRACE_MASKF, "<> ObjectBackgroundSettings.setAttentionImageName(), taskObjectId=" + taskObjectId + ", imageName=" + imageName);
        HashMap hashMap = map = this.useColorsOther ? this.attentionColors : this.attentionPatterns;
        if (map.get(taskObjectId) != null) {
            map.put(taskObjectId, imageName);
        } else {
            Trace.trace(TRACE_MASKF, "   Error, could not find taskObjectId");
        }
    }

    public String getImageURL(String imageName) {
        return "/images/fw" + imageName.substring(imageName.lastIndexOf("/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status[] getStatus() {
        Object object = this.getLock();
        synchronized (object) {
            Set keys = this.colorsStatusMap.keySet();
            return keys.toArray(new Status[keys.size()]);
        }
    }

    public String getTaskletClassName() {
        return "com.ibm.hwmca.base.settings.user.ObjectBackgroundSettingsTasklet";
    }

    public String getHelpPanelId() {
        return HELP_PANEL_ID;
    }

    public String getHelpPanelProperties() {
        return HELP_PANEL_PROPERTIES;
    }

    public Object clone() {
        ObjectBackgroundSettings clone = null;
        try {
            clone = (ObjectBackgroundSettings)super.clone();
            clone.acceptableColor = this.acceptableColor;
            clone.unacceptableColor = this.unacceptableColor;
            clone.acceptablePattern = this.acceptablePattern;
            clone.unacceptablePattern = this.unacceptablePattern;
            clone.useColorsStatus = this.useColorsStatus;
            clone.useColorsOther = this.useColorsOther;
            clone.colorsStatusMap = (HashMap)this.colorsStatusMap.clone();
            clone.patternsStatusMap = (HashMap)this.patternsStatusMap.clone();
            clone.attentionColors = (HashMap)this.attentionColors.clone();
            clone.attentionPatterns = (HashMap)this.attentionPatterns.clone();
        }
        catch (CloneNotSupportedException exc) {}
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Trace.trace(TRACE_MASKD, "-> ObjectBackgroundSettings.equals()");
        boolean result = false;
        if (obj instanceof ObjectBackgroundSettings) {
            Object object = this.getLock();
            synchronized (object) {
                ObjectBackgroundSettings settings = (ObjectBackgroundSettings)obj;
                if (settings.acceptableColor == this.acceptableColor && settings.unacceptableColor == this.unacceptableColor && settings.acceptablePattern == this.acceptablePattern && settings.unacceptablePattern == this.unacceptablePattern && settings.useColorsStatus == this.useColorsStatus && settings.useColorsOther == this.useColorsOther) {
                    result = true;
                    Iterator iterator = this.colorsStatusMap.keySet().iterator();
                    while (result && iterator.hasNext()) {
                        Status status = (Status)iterator.next();
                        if (!settings.getColorBackgroundImageName(status).equals(this.colorsStatusMap.get(status))) {
                            result = false;
                            continue;
                        }
                        if (settings.getPatternBackgroundImageName(status).equals(this.patternsStatusMap.get(status))) continue;
                        result = false;
                    }
                    if (result) {
                        ObjectId taskObjectId;
                        iterator = this.attentionColors.keySet().iterator();
                        while (result && iterator.hasNext()) {
                            taskObjectId = (ObjectId)iterator.next();
                            result = this.attentionColors.get(taskObjectId).equals(settings.attentionColors.get(taskObjectId));
                        }
                        if (result) {
                            iterator = this.attentionPatterns.keySet().iterator();
                            while (result && iterator.hasNext()) {
                                taskObjectId = (ObjectId)iterator.next();
                                result = this.attentionPatterns.get(taskObjectId).equals(settings.attentionPatterns.get(taskObjectId));
                            }
                            if (!result) {
                                Trace.trace(TRACE_MASKD, "   attention patterns do not match");
                            }
                        } else {
                            Trace.trace(TRACE_MASKD, "   attention colors do not match");
                        }
                    } else {
                        Trace.trace(TRACE_MASKD, "   status or pattern do not match");
                    }
                } else {
                    Trace.trace(TRACE_MASKD, "   booleans are not equal");
                }
            }
        } else {
            Trace.trace(TRACE_MASKD, "   obj is not an ObjectBackgroundSettings");
            Trace.trace(TRACE_MASKD, obj);
        }
        Trace.trace(TRACE_MASKD, "<- ObjectBackgroundSettings.equals(), result is " + result);
        return result;
    }

    public PersistentData getPersistentData() {
        return null;
    }

    public void setPersistentData(PersistentData data) {
    }

    private Object getLock() {
        if (this.lock == null) {
            this.lock = new Object();
        }
        return this.lock;
    }
}

